/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile'
	, 'hbs!applets/wound-care-applet/templates/tabsTemplate'
	, 'applets/wound-care-applet/core/views/AppletView'
	, 'applets/wound-care-applet/core/views/BradenReviewView'],
	function (Portal, Backbone, Marionette, $, _, jqm, template, AppletView,BradenReviewView ) {
		'use strict';

		var  tabs,tabNum;
		// tabs should follow the followning format
		// tabs = [{label:String, view: backbone/marionette view}]
		return Backbone.Marionette.Layout.extend({

				id: "wound-care-tabs",
				className: "applet scrollable tab-view",
				template: template,
				events: {
				'change input.wc-tab':'changeView'
				},
				regions:{
					'currentTabContent':'.current-tab-content'
				},
				initialize: function(options) {
					this.setClosed(false);
					if( options && options.vent ){
						this.vent = options.vent ;
					}
					else {
						this.vent = new Backbone.Wreqr.EventAggregator();
					}
					tabs = options.tabs;
					tabNum = (options && options.tabNum) || 0;
				},
				changeView: function(e){
					this.showTabNum( Number( this.$el.find(e.currentTarget ).val() ) );
				},
				showTabNum: function(num){
					var v = this.model.get('tabs')[num].view;
					if(_.isFunction( v ) ){
						v = v();
					}
					this.currentTabContent.show( v );
					v.delegateEvents();
					this.currentTabContent.currentView.$el.attr('style', Portal.scrollableZoneHeight() );
				},
				setTabNum:function(num, tab){
					this.model.get('tabs')[num] = tab;
					this.$el.find("label[for='tab"+num+"radio'] .ui-btn-text").text(tab.label);
					if(num === this.$el.find( "input[type=radio]:checked" ).val() ){
						this.showTabNum(num);
					}
					else{
						tabNum = num;
					}
				},
				onShow: function () {
					this.$el.find('.wc-tabs-container').trigger("create");
					this.showTabNum(tabNum);
				},
			onClose: function() {
				this.setClosed(true);
			},
			setClosed : function(booleanValue) {
				this.closed = booleanValue;
			},
			getClosed : function() {
				return this.closed;
			}
			});
	});
